7                     K(  Q      J(                          P    P    P    P    P   P) X  P    P    P    P 
  P 
  P    P r  Q x  P    Q    Q   Q *  Q    P                                                                        An ARexx Philosophy
by Merrill Callaway
	For the past two years, the start of the new year has prompted me to contemplate Amiga REXX (ARexx) with regard to its uses, its future, and its current possibilities, and to publicize some of my ruminations in this column.  1994 was a difficult year for all of us who develop for our favorite computer, the Amiga, and it hasn't just been the financial setbacks.  A friend of mine, a Medical Doctor who owns both a PC and an Amiga, sums up the way I feel better than anyone else.  While he said he appreciated the large amount of available and useful software for his PC, he also said, "... but I'm just not bonded to my PC."  Exactly.  Amiga quite literally spells friend to most of us.  While I have written many REXX programs for use in OS/2 on a PC, it is never as satisfying as coding and running ARexx.  Why?  Because of the unique operating environment the Amiga affords, and because of the yet unexplored possibilities of using ARexx in this rich environment.  I am going to take this opportunity to present some advanced topics and speculations to my veteran readers, including a few ideas Amiga developers should adopt from REXX on other platforms.
	I have titled this month's discussion "An ARexx Philosophy" hoping that it will connote something akin to a "world" view scaled down to fit into your computer, (and not with any sort of pretension that ARexx will answer the question, "Why are we here?").  Scaled down to the Amiga environment, the "world" is the multitasking operating environment, perhaps spread over several computers on a network.  For purposes of our discussion, level one will mean one application running on a single machine; level two will denote two or more applications running on a single machine; and level three will expand level two to include applications running simultaneously on networks or via telecommunications.  We will assume that all these applications are ARexx capable; that is they have an ARexx port for receiving ARexx commands (command strings from their own command set).  Multitasking is, of course, several programs running at once, sharing system resources on an as-needed/priority basis.  The Amiga and OS/2 by IBM are the only true, multitasking operating systems at present.  It is no accident that both of them feature built-in REXX as a process language.  All of you know that ARexx is a language for stand alone level 1 programs.  Most of you know that ARexx is a universal macro language used to write macros for applications such as the Video Toaster, ADPro, ImageFX or DirectoryOpus.  A macro may be level 1 (launched from within the application), or level 2 (launched by a separate program).  Some of my readers know that ARexx can do interprocess control (IPC).  IPC works at level 2 or level 3 and is a macro which works between or among two or more running applications.  Launching a macro from a Shell is, strictly speaking, IPC because the Shell is a program separate from the application, but we usually think of IPC as one non-AmigaDOS application program controlling another application program, perhaps by a different developer.  We are going to look at some of the finer points of using ARexx in the latter sense, some of which could be implemented now, and others only though third party developer cooperation.  First we need to discuss the seemingly difficult "object oriented programming" (OOP) concept.  It's not really so difficult, however.
Object Oriented Programming
	Picture your favorite application.  Any application may be programmed using conventional linear techniques or more highly structured OOP techniques.  Every application that deals with data or files has some means by which you can load a file.  This usually involves a Graphic User Interface (GUI) window called a "file requester" which lets you click on the name of a file, choose a directory, its parent, or a volume name, and so on; finally allowing you to click on a button to Load the file or Cancel the operation.  Since file requesters occur in almost every program, it makes sense to have just one section of code to handle this.  The application calls it as a subroutine whenever it is needed, rather than coding it every time.  Very commonly used routines such as a file requester may be implemented as shared libraries and are called as a system function when needed.  ARexx may use specifically written function libraries, too.  The concept of using subroutines or libraries is called modular programming, and is a step toward object oriented programming.  
	While it would be possible to code the actual data contained in the file requester into the routine that handles the buttons and gadgets, it is far more flexible and useful to code only the skeleton or structure of the file requester and let the program call this routine with arguments containing the current or working directory, the volume names and whatever other data is needed.  The file requester returns (or outputs) the path and file name of the chosen file to the calling program.  Perhaps this skeleton could be further modularized into related groups functions which take care of the appearance of the file requester.  For example, double clicking on a file name is an event which should call the same routine as a single click on the name followed by a click on the Load button.  The data itself may be structured by a formal data structure encoded in the program. 
	Program objects are coded, modular objects which receive Input and produce Output (or they interface or fit together) in some well defined way like parts in a machine, each with a specific purpose.  C++ is the usual language for coding applications containing objects.  When an application program is coded as a collection of these well defined structures which operate and interface as distinct modules, it is said to be "object oriented".  While I have grossly oversimplified OOP, our subject is not about low level programming.  I want only to call attention to the remarkable similarity between these low level objects, entirely contained in and accessed from within an application program, and large applications running in the Amiga multitasking environment accessible through ARexx.  The mathematically inclined among you may see this sense of program object "scale" as reminiscent of fractal images.  Fractal images, though different, "look the same" at different scales.  The analogy soon breaks down because there are practical limits to how small or large scale a program object may be, and there are important differences in the code details at each level, but my point is that object oriented structure, if it helps at a low level within an application, will help at a higher level across several applications.  Anyone who uses ARexx IPC knows implicitly that ARexx allows a certain amount of de facto object orientation at levels two and three.  This area is fertile ground for new ideas and developments in the Amiga.  Indeed it is the hottest area of REXX development on other platforms.
Lessons From REXX on Other Platforms
	Even though IBM developed REXX originally, ARexx on the Amiga is far in advance of IBM REXX on PCs, but perhaps not for long.  IBM is currently developing "Object REXX" for OS/2 to allow true object orientation among large applications.  A "Spreadsheet object" in the form of an icon may be dragged and dropped onto a "WordProcessor object" icon to generate a report, for example.  In this case the entire application is an object.  The embedded commands interfacing these two objects will be written in Object REXX, but the end user will not need to write any code.  ARexx has been able to do this sort of thing for years, although admittedly not as slick as drag and drop.  IPC with OS/2 REXX is difficult and cumbersome at present, and does not enjoy much support by third party developers.  OS/2, because it compartmentalizes multitasking programs too much, needs a superset of REXX or a third party product in order to perform IPC in any but the crudest forms, but there is a lot of development going on in this area.  There are two crucial lessons here: first, REXX is growing and maturing, while ARexx has remained static for a long time; and second, every one of the products developed for REXX in OS/2 would work much better on the Amiga!  OS/2 has three commercial and two shareware visual authoring systems for REXX to facilitate the construction of high quality GUIs, while ARexx has one freeware product, rexxarplib.library, and TRexx Professional both of which have limitations.  The former is rather out of date and does not provide many advanced features, while TRexx is heavily biassed toward the Video Toaster.  CanDo allows the building of GUIs but, alas, it has its own language and does not utilize ARexx very much.  In OS/2 the best REXX authoring system, VXREXX by Watcom, International, provides client-server database operations, Dynamic Data Exchange (like Hotlinks on the Amiga), full GUI building via drag and drop programming interface, a built-in editor, low level system and window commands, a pseudo-compiler to turn the finished project into a secure binary executable (distributed with royalty-free runtime libraries), and many more features that make it possible and feasible to market commercial applications from it.  Ironically, VXREXX is so good because one of its chief programmers is Eric Giguere, the author of the ARexx Programmer's Guide published by Commodore!  Amiga developers would do well to have a look at this product with an eye to developing a similar product for our favorite machine.  Now we will discuss an apparent contradiction.
	Are GUIs Really Better Than Command Line Interfaces?
There are other areas where the Amiga community can benefit from studying what is happening in other implementations of REXX.  Mainframe and OS/2 REXX with respect to database operations are far advanced from anything on the Amiga.  Most people would say that a program with a GUI is better than one that uses a Command Line Interface (CLI), but they would only be partly right.  While it is true the GUIs are easier to use, there is a lot of system overhead involved with GUIs and they may be a waste of resources when it comes to objects like databases.  The current trend in large corporate and business computing is to streamline databases into "engines" which are simply CLI based applications with a command set similar to what we use in ARexx to control all aspects of the application.  Instead of a GUI with a menu, command strings are issued from a CLI (a shell window) and output is sent to the screen or to a file or a printer accordingly.  The standard IBM database engine is called DB2 and the command set used to control DB2 is called SQL for Structured Query Language.  SQL commands may be issued alone or they may be embedded as REXX commands within REXX programs.  Scala is an Amiga product that operates in essentially the same way:  Its interface merely generates scripts which may or may not embed ARexx.  In exactly the same way as ARexx provides all the logic and program flow controls in Scala, so does REXX with SQL.  SQL, then, is exactly like a command set in one of our Amiga applications.  The crucial difference is that DB2 has no GUI at all.  It is simply an engine: compact, streamlined, fast.  It may reside anywhere on the network, and its command set, SQL, is universally standard.  While we are on the subject, if any Amiga developers are contemplating marketing a database suitable for the real world, they really should make it DB2/SQL compatible with embedded SQL through ARexx.  If they think the Amiga of the future will access only databases residing on an Amiga, they are unclear on the concept. 
The Case for Separate Script Driven GUIs
	For database engines, there are a variety of "front end" or GUI programs that are available depending on the platform and operating system (OS).  All of these issue SQL script commands to the underlying engine.  There are several very important advantages to this approach.  First, the system overhead is kept at a minimum.  An engine rather than a monolithic application from which the GUI is inseparable takes up less disk and memory space, operates faster, and makes fewer demands on the particular workstation.  It need not concern itself with display device drivers and such.  An important added benefit, particularly when you consider an easy to use GUI-building application such as VXREXX with full SQL and client-server linkage functions, is that REXX programmers can easily make their own custom GUI.  End users will have the GUI that meets their precise needs and they will not be forced to learn an overly complex GUI.  Of course all product that use an "engine" should and do ship with a GUI or two to use right away, but the potential to make a custom GUI without hiring an expensive consultant should not be discounted.  Programming in a high level package like VXREXX is much more cost effective.  
	One should not think that there is any system degradation because REXX is slow compared to a compiled language.  The speed of REXX is several orders of magnitude faster than the speed at which a user clicks on an interface and moves sliders.  Remember that the underlying engine, where most of the work is done, is coded in a compiled language.  You may think, "Not every application needs to be implemented this way."   Certainly a 3D animation package would suffer without an interface, but what if its interface were separate and used ARexx and a command set to communicate with its rendering/modelling engines?  Then, were the command set properly documented, the package could do double duty as an image processor for animations.  This is an area where developers of paint or 3D programs on the Amiga (Brilliance, DCTV, DeluxePaint and Imagine come to mind), simply fail to see the picture.  One or more versions of a program engine could reside on the network server and the animation work stations could contain the GUIs.  With this type of setup, programs could be smaller and more specialized.  Users could buy only the engines they need, not the features they don't need.  With IPC and ARexx each interface could have a button to call up the next engine and its GUI (or display a message stating that it isn't installed).  This could behave exactly like the present GUIs which open new pop-up menus for each feature.  Think of Word Processor versus DTP versus editor.  With the large scale OOP approach, you'd need only ONE spell checker, accessible via ARexx from any interface.  The possibilities are endless.
	ARexx and IPC have taught me to conceive of my "ideal working environment" along the ARexx paradigm.  If ARexx could work through a yet-to-be-developed product that does on the Amiga what VXREXX does in OS/2, the last piece of the puzzle, an ARexx/Intuition GUI builder would fall into place.  In my best of all environments developers would include the GUI they normally would have included, but it would be coded into "Visual ARexx" so that it could be customized.  This is not so far fetched.  Most text editors let you set up the GUI any way you want through ARexx compatible script files.  Why not make this a standard practice?  Another bonus is that the engines could reside and be maintained on a server, while GUIs, standard and custom, could reside on client machines.  I've seen a network card in Australia that does a superb job of passing ARexx commands across a network so transparently that to the uninitiated, it is difficult to tell where the program actually resides.  Object Oriented Programming has a long way to expand.  The Amiga is the best choice to "stand the world of computing on its ear" in this area.
The Need to Standardize
	The age of the competing platforms is slowly coming to an end.  If any computer is to operate in any but the most isolated environments, its developers must carefully consider compatibility questions.  Because of its specialization, the Amiga needs not so much to run other platforms' software as to find a common ground for communications with them.  For this reason, one important area in which standardization is crucial is ARexx vis a vis REXX.  Bill Hawes ran a survey last year asking ARexx users among other things if they thought rewriting ARexx to ANSI REXX standards would be a high priority.  I answered, "yes" because I view the Amiga's future as dependent upon hooking up with more mainstream platforms such as OS/2 and mainframe servers via networks; since ARexx is so close to REXX, I think this is a natural place to start.  But there is another area in which ARexx is crying for standardization.  
	I enjoy applications that have a familiar look/feel more than those with "individual" interfaces.  Why?  Because I can get on with the work and spend less time looking up how to do it in the manual.  Rugged individualism has no place in computer GUIs; why should it transpire in the ARexx command set implementation?  But it does.  I'd like to see (or even help make) a "style" guide for ARexx command sets.  Since the ADDRESS instruction controls where any ARexx command is sent, why should there be umpteen commands for umpteen applications to do the same thing such as opening a file?  My text editor has OPENDOC; ADPro has LOAD and LOADER; another application has OPENFILE.  Not only the call, but the content/format of the RESULT string (even the name of the result variable itself) has grown into a bewildering variety because no one has made a move to standardize anything.  There also ought to be certain minimum standards for "ARexx Capable" as determined by the Amiga's manufacturer or by an ARexx standards committee.
	Command sets themselves are frequently a mystery because there is such variability in the way they are documented.  I'd like to see a standard command in every ARexx command set which returns a list of all commands with their templates.  It would then be very easy to parse the result of this command into a list and link them with AmigaGuide or MultiView help files for further on-line information.  I hope that these ideas will stimulate some more development with ARexx itself.  We have only scratched the surface.
Correction:
	In the July listing "Glossary" for the FinalWriter Glossary, I failed to submit the listing I actually tested.  Many thanks to reader Jim Koepsell for calling this to my attention.  There are two glitches to fix:  First, all lines with continuation characters, (commas "," at the end of the line) should be changed to one line by removing the end of line comma and appending the next line to the end.  Second, the calls to OpenDoc.rexx and NewDoc.rexx should be in the function format:
newportname=OpenDoc()
newportname=NewDoc() 
OpenDoc.rexx and NewDoc.rexx should be in the assigned REXX: directory. Glossary should be in FWMacros drawer.  I apologize for any frustrations this error may have caused.
   M           
 z               ! *    ( .    "     *     + h    ,  f    6 !\    7 )    8 )         
          K'  K(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      (          F      &  '  .  /"  3  :8  >  >  BO  FU  H\  Hh  JO  Je  J{  K(                                                                                                                                                                                                                                                                         ! 
    ! 
    ! 
    ! 
    ! 
    "! 
    ! 
    ! 
    ! 
    ! 
    ! 
    ! 
         
               J(       
    *.  8l  F{  J(        
                       K( &     K( '           d              		
Q


|72u2;;;;;<?<J<L<    H H    (FG(    H H    (    d       '                     @                         =/  R    @      H 
-:LaserWriter 
     (  (                                                 